/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.corpws;

import edu.uiowa.physics.pw.apps.corpws.SummaryDataSetDescriptor;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.components.DasTimeRangeSelector;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DataRange;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.TimeRangeLabel;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CORPWS
extends JPanel
implements ActionListener,
TimeRangeSelectionListener {
    private DasCanvas canvas;
    private DasAxis bta;
    private DasTimeRangeSelector ts = null;
    private TimeRangeLabel timeRangeLabel;

    public CORPWS() {
        super(new BorderLayout());
        Datum startTime = SummaryDataSetDescriptor.DATA_START;
        Datum endTime = SummaryDataSetDescriptor.DATA_START.add(86400.0, Units.seconds);
        this.canvas = new DasCanvas(800, 600);
        this.add((Component)this.canvas, "Center");
        DasRow erow = new DasRow(this.canvas, 0.1, 0.533);
        DasRow brow = new DasRow(this.canvas, 0.603, 0.85);
        DasColumn column = new DasColumn(this.canvas, 0.12, 0.77);
        DasColumn cbColumn = new DasColumn(this.canvas, 0.8, 0.83);
        DasAxis eta = new DasAxis(startTime, endTime, 2);
        eta.setTickLabelsVisible(false);
        DasAxis efa = new DasAxis(Datum.create(1.0), Datum.create(1.259E7), 3, true);
        DasColorBar ecb = new DasColorBar(Datum.create(1.0E-18), Datum.create(1.0E-9), 4, true);
        ecb.setColumn(cbColumn);
        DasPlot eplot = new DasPlot(eta, efa);
        eplot.addRenderer(new SpectrogramRenderer(null, ecb));
        this.bta = new DasAxis(startTime, endTime, 2);
        this.bta.attachTo(eta);
        DasAxis bfa = new DasAxis(Datum.create(1.0), Datum.create(12590.0), 3, true);
        DasColorBar bcb = new DasColorBar(Datum.create(1.0E-10), Datum.create(10000.0), 4, true);
        bcb.setColumn(cbColumn);
        DasPlot bplot = new DasPlot(this.bta, bfa);
        bplot.addRenderer(new SpectrogramRenderer(null, bcb));
        eplot.setTitle("Cassini RPWS Key Parameters!C!CElectric Spectral Densities");
        ecb.setLabel("V!U2!Nm!U-2!NHz!U-1!N");
        efa.setLabel("Hz");
        bplot.setTitle("Magnetic Spectral Densities");
        bcb.setLabel("nT!U2!NHz!U-1!N");
        bfa.setLabel("Hz");
        this.bta.setLabel("SCET");
        try {
            eplot.getRenderer(0).setDataSetID("class:edu.uiowa.physics.pw.apps.corpws.SummaryDataSetDescriptor?dataset=e");
            bplot.getRenderer(0).setDataSetID("class:edu.uiowa.physics.pw.apps.corpws.SummaryDataSetDescriptor?dataset=b");
        }
        catch (DasException de) {
            DasExceptionHandler.handle(de);
        }
        this.canvas.add(eplot, erow, column);
        this.canvas.add(bplot, brow, column);
        DataRange dataRange = eta.getDataRange();
        this.timeRangeLabel = new TimeRangeLabel(dataRange);
        PropertyChangeListener x = this.timeRangeLabel.createDataRangePropertyListener();
        dataRange.addPropertyChangeListener("log", x);
        dataRange.addPropertyChangeListener("minimum", x);
        dataRange.addPropertyChangeListener("maximum", x);
        this.canvas.add(this.timeRangeLabel, erow, column);
        JPanel controlPanel = new JPanel(new FlowLayout(2));
        this.ts = new DasTimeRangeSelector(startTime, endTime);
        controlPanel.add(this.ts);
        this.ts.addTimeRangeSelectionListener(this);
        JButton b = new JButton("Print");
        b.setActionCommand("print");
        b.addActionListener(this);
        controlPanel.add(b);
        b = new JButton("Quit");
        b.setActionCommand("quit");
        b.addActionListener(this);
        controlPanel.add(b);
        this.add((Component)controlPanel, "South");
    }

    public void setTimeRange(Datum startTime, Datum endTime) {
        this.bta.setDataRange(startTime, endTime);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("quit")) {
            System.exit(0);
        } else if (command.equals("print")) {
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setPrintable(this.canvas);
            boolean printIt = pj.printDialog();
            if (printIt) {
                try {
                    pj.print();
                }
                catch (PrinterException ex) {
                    DasDie.println(ex);
                }
            }
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("RPWS");
        f.setDefaultCloseOperation(3);
        CORPWS app = new CORPWS();
        f.setContentPane(app);
        f.pack();
        f.setVisible(true);
    }

    public void timeRangeSelected(TimeRangeSelectionEvent e) {
        DatumRange range = e.getRange();
        this.setTimeRange(range.min(), range.max());
    }
}

