/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.SimpleXMLDocHandler;
import com.lowagie.text.pdf.SimpleXMLParser;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;

public class XfdfReader
implements SimpleXMLDocHandler {
    private boolean foundRoot = false;
    private Stack fieldNames = new Stack();
    private Stack fieldValues = new Stack();
    HashMap fields;
    String fileSpec;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XfdfReader(String filename) throws IOException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(filename);
            SimpleXMLParser.parse((SimpleXMLDocHandler)this, fin);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                fin.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (Exception e) {
            return;
        }
        fin.close();
    }

    public XfdfReader(byte[] xfdfIn) throws IOException {
        SimpleXMLParser.parse((SimpleXMLDocHandler)this, new ByteArrayInputStream(xfdfIn));
    }

    public HashMap getFields() {
        return this.fields;
    }

    public String getField(String name) {
        return (String)this.fields.get(name);
    }

    public String getFieldValue(String name) {
        String field = (String)this.fields.get(name);
        if (field == null) {
            return null;
        }
        return field;
    }

    public String getFileSpec() {
        return this.fileSpec;
    }

    public void startElement(String tag, HashMap h) {
        if (!this.foundRoot) {
            if (!tag.equals("xfdf")) {
                throw new RuntimeException("Root element is not Bookmark.");
            }
            this.foundRoot = true;
        }
        if (!tag.equals("xfdf")) {
            if (tag.equals("f")) {
                this.fileSpec = (String)h.get("href");
            } else if (tag.equals("fields")) {
                this.fields = new HashMap();
            } else if (tag.equals("field")) {
                String fName = (String)h.get("name");
                this.fieldNames.push(fName);
            } else if (tag.equals("value")) {
                this.fieldValues.push("");
            }
        }
    }

    public void endElement(String tag) {
        if (tag.equals("value")) {
            String fName = (String)this.fieldNames.pop();
            String fVal = (String)this.fieldValues.pop();
            this.fields.put(fName, fVal);
        }
    }

    public void startDocument() {
        this.fileSpec = new String("");
    }

    public void endDocument() {
    }

    public void text(String str) {
        if (this.fieldNames.isEmpty() || this.fieldValues.isEmpty()) {
            return;
        }
        String val = (String)this.fieldValues.pop();
        val = String.valueOf(val) + str;
        this.fieldValues.push(val);
    }
}

